unit ProcessDetailsForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, ProcessClasses, System.Resources;

type
  TProcessDetailsForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    cbCheckResponding: System.Windows.Forms.CheckBox;
    btnBrowse: System.Windows.Forms.Button;
    ofdProcess: System.Windows.Forms.OpenFileDialog;
    btnOK: System.Windows.Forms.Button;
    btnCancel: System.Windows.Forms.Button;
    tbProcessName: System.Windows.Forms.TextBox;
    label1: System.Windows.Forms.Label;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TProcessDetailsForm_Load(sender: System.Object; e: System.EventArgs);
    procedure btnBrowse_Click(sender: System.Object; e: System.EventArgs);
    procedure btnOK_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    FProcess: TProcess;
    procedure PopulateControls;
  public
    constructor Create;
    class function ShowProcessDetails(var pProcess: TProcess): System.Windows.Forms.DialogResult;
  end;

implementation

uses
  System.Globalization;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TProcessDetailsForm.InitializeComponent;
var
  resources: System.Resources.ResourceManager;
begin
  resources := System.Resources.ResourceManager.Create(TypeOf(TProcessDetailsForm));
  Self.cbCheckResponding := System.Windows.Forms.CheckBox.Create;
  Self.btnBrowse := System.Windows.Forms.Button.Create;
  Self.ofdProcess := System.Windows.Forms.OpenFileDialog.Create;
  Self.btnOK := System.Windows.Forms.Button.Create;
  Self.btnCancel := System.Windows.Forms.Button.Create;
  Self.tbProcessName := System.Windows.Forms.TextBox.Create;
  Self.label1 := System.Windows.Forms.Label.Create;
  Self.SuspendLayout;
  // 
  // cbCheckResponding
  // 
  Self.cbCheckResponding.Location := System.Drawing.Point.Create(10, 43);
  Self.cbCheckResponding.Name := 'cbCheckResponding';
  Self.cbCheckResponding.Size := System.Drawing.Size.Create(128, 24);
  Self.cbCheckResponding.TabIndex := 3;
  Self.cbCheckResponding.Text := 'Check Responding';
  // 
  // btnBrowse
  // 
  Self.btnBrowse.Image := (System.Drawing.Image(resources.GetObject('btnBrowse.Image')));
  Self.btnBrowse.Location := System.Drawing.Point.Create(290, 17);
  Self.btnBrowse.Name := 'btnBrowse';
  Self.btnBrowse.Size := System.Drawing.Size.Create(20, 20);
  Self.btnBrowse.TabIndex := 2;
  Include(Self.btnBrowse.Click, Self.btnBrowse_Click);
  // 
  // ofdProcess
  // 
  Self.ofdProcess.DefaultExt := 'exe';
  Self.ofdProcess.Filter := 'Executables|*.exe';
  // 
  // btnOK
  // 
  Self.btnOK.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.btnOK.Location := System.Drawing.Point.Create(170, 67);
  Self.btnOK.Name := 'btnOK';
  Self.btnOK.TabIndex := 4;
  Self.btnOK.Text := 'OK';
  Include(Self.btnOK.Click, Self.btnOK_Click);
  // 
  // btnCancel
  // 
  Self.btnCancel.DialogResult := System.Windows.Forms.DialogResult.Cancel;
  Self.btnCancel.Location := System.Drawing.Point.Create(258, 67);
  Self.btnCancel.Name := 'btnCancel';
  Self.btnCancel.TabIndex := 5;
  Self.btnCancel.Text := 'Cancel';
  // 
  // tbProcessName
  // 
  Self.tbProcessName.Location := System.Drawing.Point.Create(98, 17);
  Self.tbProcessName.Name := 'tbProcessName';
  Self.tbProcessName.Size := System.Drawing.Size.Create(192, 20);
  Self.tbProcessName.TabIndex := 1;
  Self.tbProcessName.Text := '';
  // 
  // label1
  // 
  Self.label1.Location := System.Drawing.Point.Create(10, 19);
  Self.label1.Name := 'label1';
  Self.label1.Size := System.Drawing.Size.Create(88, 16);
  Self.label1.TabIndex := 0;
  Self.label1.Text := 'Process Name';
  // 
  // TProcessDetailsForm
  // 
  Self.AcceptButton := Self.btnOK;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.CancelButton := Self.btnCancel;
  Self.ClientSize := System.Drawing.Size.Create(342, 106);
  Self.Controls.Add(Self.btnBrowse);
  Self.Controls.Add(Self.btnOK);
  Self.Controls.Add(Self.btnCancel);
  Self.Controls.Add(Self.tbProcessName);
  Self.Controls.Add(Self.label1);
  Self.Controls.Add(Self.cbCheckResponding);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedSingle;
  Self.Icon := (System.Drawing.Icon(resources.GetObject('$this.Icon')));
  Self.MaximizeBox := False;
  Self.MinimizeBox := False;
  Self.Name := 'TProcessDetailsForm';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'Process Details';
  Self.TransparencyKey := System.Drawing.Color.Fuchsia;
  Include(Self.Load, Self.TProcessDetailsForm_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TProcessDetailsForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TProcessDetailsForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

class function TProcessDetailsForm.ShowProcessDetails(var pProcess: TProcess): System.Windows.Forms.DialogResult;
var
  lForm: TProcessDetailsForm;
begin
  lForm := TProcessDetailsForm.Create;
  lForm.FProcess := pProcess;
  Result := lForm.ShowDialog;
end;

procedure TProcessDetailsForm.btnBrowse_Click(sender: System.Object; e: System.EventArgs);
begin
  if (ofdProcess.ShowDialog = System.Windows.Forms.DialogResult.OK) then
    tbProcessName.Text := ofdProcess.FileName;
end;

procedure TProcessDetailsForm.btnOK_Click(sender: System.Object; e: System.EventArgs);
begin
  FProcess.Path := tbProcessName.Text;
  if (FProcess is TWatchedProcess) then
    TWatchedProcess(FProcess).CheckResponding := cbCheckResponding.Checked;
end;

procedure TProcessDetailsForm.TProcessDetailsForm_Load(sender: System.Object;
    e: System.EventArgs);
begin
  PopulateControls;
end;

procedure TProcessDetailsForm.PopulateControls;
begin
  tbProcessName.Text := FProcess.Path;
  if (FProcess is TWatchedProcess) then
  begin
    cbCheckResponding.Checked := TWatchedProcess(FProcess).CheckResponding;
    cbCheckResponding.Visible := true;
  end
  else
    cbCheckResponding.Visible := false;

  if Assigned(btnBrowse.Image) then
    Bitmap(btnBrowse.Image).MakeTransparent;
end;

end.
